//	CDialogCopy.c

#ifndef _H_CDialogCopy
#define _H_CDialogCopy

#include "CDialog.h"

enum {
	kCopy_NONE, 
	
	kCopy_STOP_BUTTON, 
	kCopy_ITEM_REMAIN_STAT, 
	kCopy_ITEM_REMAIN_VERB, 
	kCopy_PROGRESS_BAR, 
	kCopy_TWIRLY,  
	kCopy_TIME_REMAIN_STAT, 
	kCopy_TIME_REMAIN_VERB, 
	kCopy_COPYING_STAT, 
	kCopy_FROM_STAT, 
	kCopy_TO_STAT, 
	kCopy_BYTES_COPIED_STAT, 
	kCopy_COPYING_VERB, 
	kCopy_FROM_VERB, 
	kCopy_TO_VERB, 
	kCopy_BYTES_COPIED_VERB, 
	kCopy_BEVEL_LINE, 
	
	kCopy_NUMTYPES
};

enum {
	DCpy_ItemStr_ITEM_REMAIN_STAT,
	DCpy_ItemStr_ITEM_REMAIN_VERB,
	DCpy_ItemStr_TIME_REMAIN_STAT,
	DCpy_ItemStr_COPYING_STAT,
	DCpy_ItemStr_FROM_STAT,
	DCpy_ItemStr_TO_STAT,
	DCpy_ItemStr_BYTES_COPIED_STAT,
	DCpy_ItemStr_COPYING_VERB,
	DCpy_ItemStr_FROM_VERB,
	DCpy_ItemStr_TO_VERB,
	DCpy_ItemStr_MAX
};

typedef short	DCpy_ItemStrType;

#define		kCopyWindowWidth				280

/***************************************/

class CDialogCopy;

CDialogCopy		*ShowCopyDialog(void);
void			DoFakeCopy(void);

class CDialogCopy : public CDialog {

	public:		Boolean		IDialogCopy(void);
	virtual		void		Dispose(void);
	
	void		HideCopyDialog(void);
	void		SetAsProgress(Boolean delayB, short numItems);
	void		IncrementProgress(Boolean delayB, char *progZ);

	virtual		void		DoClick(EventRecord *event);
	virtual		void		DoKeyDown(EventRecord *event);
	virtual		void		Move(EventRecord *event);
	
	virtual		void		DialogItemStandardDrawProc(
		DialogItemIndex	itemNo,
		Rect			*itemRectP);

	void		SetDelayTicks(ulong delayTicksL);
	void		FlushUpdates(void);
	void		SetMaxProgress(ulong maxBytesUL);
	void		SetItemRemain(ulong itemRemainUL);
	OSErr		SetProgress(ulong curBytesUL);
	void		SetProgStrings(
		char	*copyingZ, 
		char	*fromZ, 
		char	*toZ);
	
	/******************************************/
	ulong			i_itemRemainUL;
	ulong			i_maxBytesUL;
	ulong			i_curBytesUL;
	
	ulong			i_startTicks;
	ulong			i_lastProgressTicks;
	ulong			i_lastTimeEstTicks;
	ulong			i_delayTicksL;
	
	Boolean			i_showingB;
	Boolean			i_twirledDownB;
	Boolean			i_cancelB;
	
	DGI_ItemRec		i_itemStrTable[DCpy_ItemStr_MAX];

	typedef		 	CDialog		_inherited;
};

#endif